@echo off

:: --- Ensure script is running with Administrator privileges ---
net session >nul 2>&1
if %errorlevel% NEQ 0 (
    echo Requesting administrator privileges...
    powershell -Command "Start-Process '%~f0' -Verb RunAs"
    exit /b
)

set "SCRIPT_DIR=%~dp0"
set "SCRIPT_DIR=%SCRIPT_DIR:~0,-1%"

set "INTEL_API_SERVICE=%SCRIPT_DIR%\Intel(R) AI Assistant Builder_Service_Installer_SA_2.0.0.902.exe"
set "ASUS_AI_SuperBuild=%SCRIPT_DIR%\setup.exe"
set "AISB_PATH=%USERPROFILE%\Desktop\ASUS AI SuperBuild.lnk"
set "AISB_CONTENT=Do you want to launch ASUS AI SuperBuild?"
set "AISB_TITLE=ASUS AI SuperBuild"


:: --- Check if Intel AI Service is already installed ---
if exist "C:\Program Files\Intel Corporation\Intel(R) AI Assistant Builder" (
    echo Intel AI Assistant Builder API Service already installed. Skipping installation...
) else (
    echo Installing Intel AI Assistant Builder API Service...
    "%INTEL_API_SERVICE%"
)

:: --- Uninstall previous ASUS AI SuperBuild using PowerShell (replacement for wmic) ---
echo Uninstalling previous ASUS AI SuperBuild...
powershell -NoProfile -Command ^
    "Get-WmiObject -Class Win32_Product | Where-Object { $_.Name -like '*AISuperBuildMsi*' } | ForEach-Object { $_.Uninstall() }" >nul 2>&1

:: --- Install new ASUS AI SuperBuild ---
echo Installing ASUS AI SuperBuild...
"%ASUS_AI_SuperBuild%" /passive /norestart
set RESULT=%errorlevel%

if %RESULT%==0 (
  echo Install succeeded.
) else (
  echo Install fail!!
  exit 1
)

:: --- Ask user if they want to launch the app ---
powershell -command "Add-Type -AssemblyName System.Windows.Forms; $r=[System.Windows.Forms.MessageBox]::Show('%AISB_CONTENT%','%AISB_TITLE%','YesNo'); if($r -eq 'Yes'){Start-Process '%AISB_PATH%'}"

