@echo off
@title Install AsusDialControlPanelToolkit
set version=1.2.9.0
set current_version=

echo Update version: %version%
for /F "tokens=3*" %%a in ('reg QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\ASUS\ASUS Dial Control Panel Toolkit" /V DisplayVersion ^|findstr /ri "REG_SZ"') DO (set current_version=%%a)
echo Current version: %current_version%

if "%current_version%" == "" goto update
if %current_version% geq %version% goto no_update

:update	
echo =====================================================================
echo Welcome to use AsusDialControlPanelToolkit
echo Please wait for the following installation steps
echo [First]  Removing the old version of AsusDialControlPanelToolkit...
REG ADD "HKEY_LOCAL_MACHINE\SOFTWARE\ASUS\ASUS Dial Control Panel Toolkit" /v IsUpdate /t REG_SZ /d 1 /f >nul
msiexec.exe /x {A01CF1E6-8E7C-4986-8A1F-F1D28E3138B8} /qn /norestart
REG DELETE  "HKEY_LOCAL_MACHINE\SOFTWARE\ASUS\ASUS Dial Control Panel Toolkit" /v IsUpdate /f >nul
cd /d %~dp0
echo [Second] Installing the new version of AsusDialControlPanelToolkit...
msiexec.exe /i AsusDialControlPanelToolkit.msi /qn /norestart
echo Update successfully!
exit /b %errorlevel%

:no_update
echo Current version is greater than Update version,so no need update
exit /b 9000
